(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     81962,       5567]*)
(*NotebookOutlinePosition[     83070,       5604]*)
(*  CellTagsIndexPosition[     83026,       5600]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[CellGroupData[{Cell[TextData[
"Euler's Method and \nVarious Modifications"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"These calculations support the introduction to numerical methods that \
appears in chapter 1. The problem illustrated in these cells is that \
illustrated in the text. Feel free to make modification to these cells to try \
problems of your own. \n\nYou can change\n         f[x, y]\n         x0, y0\n \
        h\n         xn (the right hand end of the interval)\n         Euler's \
method itself, by adding additional terms.\n\nSave your experimental \
notebooks in files with different names to avoid corrupting the original \
file."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["Define the differential equation: y'[x]=f[x,y[x]]"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(f[x_, y_] = x + 2\ y\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(x + 2\ y\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Initial point"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \({x0, y0} = {1, 1\/2}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({1, 1\/2}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Exact Solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "==", 
              \(f[x, y[x]]\)}], ",", \(y[x0] == y0\)}], "}"}], ",", \(y[x]\), 
        ",", "x"}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{y[x] \[Rule] \(-\(1\/4\)\) + 5\/4\ E\^\(\(-2\) + 2\ x\) - x\/2}}\)], 
  "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(s[x_] = y[x] /. %\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    \(\(-\(1\/4\)\) + 5\/4\ E\^\(\(-2\) + 2\ x\) - x\/2\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(p = Plot[s[x], {x, x0, x0 + 2}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.47619 0.0147151 0.00885149 [
[(1.5)] .2619 .01472 0 2 Msboxa
[(2)] .5 .01472 0 2 Msboxa
[(2.5)] .7381 .01472 0 2 Msboxa
[(3)] .97619 .01472 0 2 Msboxa
[(10)] .01131 .10323 1 0 Msboxa
[(20)] .01131 .19174 1 0 Msboxa
[(30)] .01131 .28026 1 0 Msboxa
[(40)] .01131 .36877 1 0 Msboxa
[(50)] .01131 .45729 1 0 Msboxa
[(60)] .01131 .5458 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(1.5)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(2)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(2.5)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(3)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .10323 m
.03006 .10323 L
s
P
[(10)] .01131 .10323 1 0 Mshowa
p
.002 w
.02381 .19174 m
.03006 .19174 L
s
P
[(20)] .01131 .19174 1 0 Mshowa
p
.002 w
.02381 .28026 m
.03006 .28026 L
s
P
[(30)] .01131 .28026 1 0 Mshowa
p
.002 w
.02381 .36877 m
.03006 .36877 L
s
P
[(40)] .01131 .36877 1 0 Mshowa
p
.002 w
.02381 .45729 m
.03006 .45729 L
s
P
[(50)] .01131 .45729 1 0 Mshowa
p
.002 w
.02381 .5458 m
.03006 .5458 L
s
P
[(60)] .01131 .5458 1 0 Mshowa
p
.001 w
.02381 .03242 m
.02756 .03242 L
s
P
p
.001 w
.02381 .05012 m
.02756 .05012 L
s
P
p
.001 w
.02381 .06782 m
.02756 .06782 L
s
P
p
.001 w
.02381 .08553 m
.02756 .08553 L
s
P
p
.001 w
.02381 .12093 m
.02756 .12093 L
s
P
p
.001 w
.02381 .13864 m
.02756 .13864 L
s
P
p
.001 w
.02381 .15634 m
.02756 .15634 L
s
P
p
.001 w
.02381 .17404 m
.02756 .17404 L
s
P
p
.001 w
.02381 .20945 m
.02756 .20945 L
s
P
p
.001 w
.02381 .22715 m
.02756 .22715 L
s
P
p
.001 w
.02381 .24485 m
.02756 .24485 L
s
P
p
.001 w
.02381 .26256 m
.02756 .26256 L
s
P
p
.001 w
.02381 .29796 m
.02756 .29796 L
s
P
p
.001 w
.02381 .31567 m
.02756 .31567 L
s
P
p
.001 w
.02381 .33337 m
.02756 .33337 L
s
P
p
.001 w
.02381 .35107 m
.02756 .35107 L
s
P
p
.001 w
.02381 .38648 m
.02756 .38648 L
s
P
p
.001 w
.02381 .40418 m
.02756 .40418 L
s
P
p
.001 w
.02381 .42188 m
.02756 .42188 L
s
P
p
.001 w
.02381 .43959 m
.02756 .43959 L
s
P
p
.001 w
.02381 .47499 m
.02756 .47499 L
s
P
p
.001 w
.02381 .4927 m
.02756 .4927 L
s
P
p
.001 w
.02381 .5104 m
.02756 .5104 L
s
P
p
.001 w
.02381 .5281 m
.02756 .5281 L
s
P
p
.001 w
.02381 .56351 m
.02756 .56351 L
s
P
p
.001 w
.02381 .58121 m
.02756 .58121 L
s
P
p
.001 w
.02381 .59891 m
.02756 .59891 L
s
P
p
.001 w
.02381 .61662 m
.02756 .61662 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
.02381 .01914 m
.06349 .02078 L
.10317 .02278 L
.14286 .02521 L
.18254 .02815 L
.22222 .03169 L
.2619 .03594 L
.30159 .04103 L
.34127 .0471 L
.38095 .05434 L
.42063 .06297 L
.46032 .07322 L
.5 .08541 L
.53968 .09986 L
.57937 .11701 L
.61905 .13734 L
.65873 .16141 L
.69841 .18992 L
.7381 .22367 L
.77778 .26361 L
.81746 .31085 L
.85714 .36673 L
.89683 .43281 L
.93651 .51095 L
.97619 .60332 L
s
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Euler's Method"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Find the solution on the interval [1, 3]. Use h=0.1. Set xn=3."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(h = 0.1\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0.1\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(xn = 3\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(3\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[
"Calculate the number of steps required to get from x0 to xn stepping by h."],
   "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(NumSteps = Ceiling[\(xn - x0\)\/h]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(20\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Here is the basic Euler method"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(euler[{x_, y_}] := {x + h, y + h\ f[x, y]}\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(euler[{x, y}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({0.5 + x, y + 0.5\ \((x + 2\ y)\)}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData[{
  "Calculate ",
  StyleBox["NumSteps",
    FontFamily->"Courier",
    FontSize->12],
  " points"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(e1t = NestList[euler, {x0, y0}, NumSteps]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1, 1\/2}, {1.1, 0.7}, {1.2, 0.95}, {1.3, 1.26}, {1.4, 1.642}, {1.5, 
        2.1104}, {1.6, 2.68248}, {1.7, 3.378976}, {1.8, 4.2247712}, {1.9, 
        5.24972544}, {2., 6.489670528}, {2.1, 7.9876046336}, {2.2, 
        9.79512556032}, {2.3, 11.974150672384}, {2.4, 14.5989808068608}, {
        2.5, 17.75877696823296}, {2.6, 21.560532361879552}, {2.7, 
        26.1326388342554624}, {2.799999999999999999, 31.62916660110655488}, {
        2.899999999999999999, 38.23499992132786586}, {2.999999999999999999, 
        46.17199990559343903}}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData[{
  "Calculate '",
  StyleBox["NumSteps'",
    FontFamily->"Courier",
    FontSize->12],
  " points on the exact solution"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(yt = Table[N[{x0 + k\ h, s[x0 + k\ h]}], {k, 0, NumSteps}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1., 0.5}, {1.1, 0.7267534477002122917}, {1.2, 1.0147808720515879}, {
        1.3, 1.377648500488136219}, {1.4, 1.831926160615584505}, {1.5, 
        2.39785228557380654}, {1.6, 3.100146153420684364}, {1.7, 
        3.968999958555843234}, {1.8, 5.041290530493893501}, {1.9, 
        6.362059330516182618}, {2., 7.986320123663312785}, {2.1, 
        9.981266874292651154}, {2.2, 12.42897047580200205}, {2.3, 
        15.42967254375211301}, {2.4, 19.10580846387131234}, {2.5, 
        23.60692115398458466}, {2.6, 29.11566274638668582}, {2.7, 
        35.85512505924626669}, {2.8, 44.09779305459748467}, {2.9, 
        54.17648061662602874}, {3., 66.49768754143029888}}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Use NDSolve"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "==", 
              \(x + 2\ y[x]\)}], ",", \(y[x0] == y0\)}], "}"}], ",", \(y[x]\),
         ",", \({x, x0, xn}\)}], "]"}]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{y[x] \[Rule] 
          \(InterpolatingFunction[{1., 
                3.}, {{1., 1., {0.5, 0}, {0}}, {1.000727606875108999, 
                  1., {0.5014578646610779249, 2.003643328493192053}, {0}}, {
                  1.001455213750217998, 
                  1.000727606875108999, {0.502918384101885098, 
                    2.007291974238671697}, {0}}, {1.010134119072599557, 
                  1.001455213750217998, {0.5205299921886529931, 
                    2.051194074998499561, 2.529241829992724715}, {0, 0}}, {
                  1.018813024394981115, 
                  1.010134119072599557, {0.5385259582219440162, 
                    2.095864883435394476, 2.573527811260700534}, {0, 0}}, {
                  1.027491929717362674, 
                  1.018813024394981115, {0.5569130123097939568, 
                    2.141317895925629999, 2.618591331617549252}, {0, 0}}, {
                  1.053613156542718638, 
                  1.027491929717362674, {0.6146786543938316367, 
                    2.282969858983340152, 2.791762618155286751, 
                    2.050150177305898793}, {0, 0, 0}}, {1.079734383368074603, 
                  1.053613156542718638, {0.6762454482816882477, 
                    2.432225645963546961, 2.929757089220662191, 
                    1.85734961613352306}, {0, 0, 0}}, {1.105855610193430567, 
                  1.079734383368074603, {0.7418146446735262917, 
                    2.589484714296978854, 3.086775174998827249, 
                    1.954923167702760657}, {0, 0, 0}}, {1.131976837018786531, 
                  1.105855610193430567, {0.8116008628108490134, 
                    2.755178362631004972, 3.252353717348951249, 
                    2.06027442061117309}, {0, 0, 0}}, {1.176725907117658869, 
                  1.131976837018786531, {0.941609878896928375, 
                    3.059944631457473926, 3.56047946348803162, 
                    2.398606023967105663, 1.449225776309239046}, {0, 0, 0, 
                    0}}, {1.221474977216531206, 
                  1.176725907117658869, {1.08588532586867371, 
                    3.393245938369671633, 3.894082013500856102, 
                    2.610751463122493015, 1.317210227849767037}, {0, 0, 0, 
                    0}}, {1.266224047315403544, 
                  1.221474977216531206, {1.245764248876778306, 
                    3.757752722030857777, 4.257067995099723815, 
                    2.819497796224792919, 1.241707546671190587}, {0, 0, 0, 
                    0}}, {1.310973117414275882, 
                  1.266224047315403544, {1.422706720783338001, 
                    4.156386285584244646, 4.65563552821616395, 
                    3.083517809084291926, 1.358355167990699612}, {0, 0, 0, 
                    0}}, {1.355722187513148219, 
                  1.310973117414275882, {1.61831032183273338, 
                    4.592342531914784507, 5.091534725458464631, 
                    3.372368291460135557, 1.486039273348986708}, {0, 0, 0, 
                    0}}, {1.426872247030058681, 
                  1.355722187513148219, {1.972103935428812498, 
                    5.371078290265785575, 5.869972048551360567, 
                    3.899036800048774559, 1.914490232798473097, 
                    0.8241437194551967147}, {0, 0, 0, 0, 0}}, {
                  1.498022306546969143, 
                  1.426872247030058681, {2.385438146122221841, 
                    6.268897560097546892, 6.769827262741197327, 
                    4.528162940593562998, 2.335801821443157234, 
                    0.9682023089388576776}, {0, 0, 0, 0, 0}}, {
                  1.569172366063879605, 
                  1.498022306546969143, {2.867422252044886506, 
                    7.304018007985645148, 7.803694359265268731, 
                    5.195345104540456287, 2.539889242108636932, 
                    0.8103940486905727819}, {0, 0, 0, 0, 0}}, {
                  1.640322425580790067, 
                  1.569172366063879605, {3.428553219362774892, 
                    8.497428210787946356, 8.996787977469299732, 
                    5.985988601174268015, 2.908798236390166575, 
                    0.9010318593644476078}, {0, 0, 0, 0, 0}}, {
                  1.711472485097700528, 
                  1.640322425580790067, {4.080933913454199992, 
                    9.873339253196985793, 10.37270706979830257, 
                    6.902811211131315007, 3.359944006589736663, 
                    1.047880274091594178}, {0, 0, 0, 0, 0}}, {
                  1.78262254461461099, 
                  1.711472485097700528, {4.83851873309824066, 
                    11.45965889907581013, 11.95888462297233212, 
                    7.957631618501129188, 3.869859552484057526, 
                    1.202069127885214897}, {0, 0, 0, 0, 0}}, {
                  1.892562502296410704, 
                  1.78262254461461099, {6.254157604912931254, 
                    14.40086955502624958, 14.8981498061908463, 
                    9.900327402670377527, 4.817746701225647544, 
                    1.724915692882553654, 0.5049963383643801549}, {0, 0, 0, 
                    0, 0, 0}}, {2.002502459978210418, 
                  1.892562502296410704, {8.031449498730450515, 
                    18.06538768365360585, 18.56605061205733854, 
                    12.38609745801804852, 6.231720787896781224, 
                    2.538590759966270014, 0.7478356626653477085}, {0, 0, 0, 
                    0, 0, 0}}, {2.112442417660010133, 
                  2.002502459978210418, {10.25934661988897675, 
                    22.63113921106668139, 23.13100928062946607, 
                    15.41580274146867414, 7.666216119600816587, 
                    2.907908835767940088, 0.6851832570296420361}, {0, 0, 0, 
                    0, 0, 0}}, {2.222382375341809847, 
                  2.112442417660010133, {13.04866771095943627, 
                    28.31971480499360336, 28.81788484913876541, 
                    19.18832540093625674, 9.470217433168435582, 
                    3.46428141336715134, 0.7379385518832371324}, {0, 0, 0, 0, 
                    0, 0}}, {2.332322333023609561, 
                  2.222382375341809847, {16.53747565560324768, 
                    35.4072620755244839, 35.90550767167631834, 
                    23.91324240334041436, 11.82264169893690204, 
                    4.354680461093641843, 0.941901119392554675}, {0, 0, 0, 0, 
                    0, 0}}, {2.442262290705409275, 
                  2.332322333023609561, {20.89779559365076553, 
                    44.23784139437644105, 44.73547059347749984, 
                    29.79113101327223299, 14.71548736126085153, 
                    5.397586756276953218, 1.154942092359505367}, {0, 0, 0, 0, 
                    0, 0}}, {2.552202248387208989, 
                  2.442262290705409275, {26.343956350041841, 
                    55.24009867932003595, 55.7370561277153819, 
                    37.11701873023828863, 18.33396303098265407, 
                    6.727053729427590443, 1.441776063963406518}, {0, 0, 0, 0, 
                    0, 0}}, {2.662142206069008704, 
                  2.552202248387208989, {33.1429950593305221, 
                    68.94811185356312838, 69.44447091168643996, 
                    46.24677954441061887, 22.84941804990661674, 
                    8.392333701341452981, 1.802693862602209968}, {0, 0, 0, 0, 
                    0, 0}}, {2.772082163750808418, 
                  2.662142206069008704, {41.62762202270973225, 
                    86.02730137078818371, 86.52269222851347404, 
                    57.61916846948459872, 28.46436872438055588, 
                    10.44805900976800724, 2.240608038107792928}, {0, 0, 0, 0, 
                    0, 0}}, {2.882022121432608132, 
                  2.772082163750808418, {52.2123693015456557, 
                    107.3067293892849782, 107.8009855683176652, 
                    71.78938995727559207, 35.46526437904097357, 
                    13.01932149205807372, 2.793065330856166188}, {0, 0, 0, 0, 
                    0, 0}}, {2.991962079114407846, 
                  2.882022121432608132, {65.41371376878617522, 
                    133.8193506151005206, 134.312219110860423, 
                    89.44461239281001663, 44.18803743921361102, 
                    16.22248118625106383, 3.480684492980210999}, {0, 0, 0, 0, 
                    0, 0}}, {3., 
                  2.991962079114407846, {66.49806788654854889, 
                    135.9961357682165907, 136.5110618291867762, 
                    92.56374164027915892, 104.340878284614937, 
                    1061.392669885164645, 7226.204755482877533}, {0, 0, 0, 0, 
                    0, 0}}}]\)[x]}}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[BoxData[
    \(\(ns[x_] = y[x] /. %\[LeftDoubleBracket]1\[RightDoubleBracket]; \)\)], 
  "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["Calculate 20 points on the NDSolve solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(nst = Table[N[{x0 + k\ h, ns[x0 + k\ h]}], {k, 0, NumSteps}]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    \({{1., 0.5}, {1.1, 0.7267570789531039887}, {1.2, 1.01478572255640828}, {
        1.3, 1.377654733442919803}, {1.4, 1.831935129534192451}, {1.5, 
        2.397862614029360329}, {1.6, 3.100159313500620389}, {1.7, 
        3.969017044936328525}, {1.8, 5.041312418736765334}, {1.9, 
        6.362092393734541681}, {2., 7.986357661489827795}, {2.1, 
        9.981312020227565656}, {2.2, 12.4290293416447089}, {2.3, 
        15.42974725967460045}, {2.4, 19.10590260701012453}, {2.5, 
        23.60704012885010756}, {2.6, 29.1158129358303598}, {2.7, 
        35.85531439680234538}, {2.8, 44.09803198001826165}, {2.9, 
        54.17678215356407229}, {3., 66.49806788654854889}}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Modify Euler to include the second derivative"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(f2[x_, y_] = 
      \[PartialD]\_x f[x, y] + \[PartialD]\_y f[x, y]\ f[x, y]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(1 + 2\ \((x + 2\ y)\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[BoxData[
    \(euler2[{x_, y_}] := {x + h, y + h\ f[x, y] + 1\/2\ h\^2\ f2[x, y]}\)], 
  "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(euler2[{x, y}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({0.5 + x, y + 0.5\ \((x + 2\ y)\) + 0.125\ \((1 + 2\ \((x + 2\ y)\))\)}
      \)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(Expand[euler2[{x, y}]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({0.1 + x, 0.005 + 0.11\ x + 1.22\ y}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(e2t = NestList[euler2, {x0, y0}, NumSteps]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1, 1\/2}, {1.1, 0.725}, {1.2, 1.0105}, {1.3, 1.36981}, {1.4, 
        1.8191682}, {1.5, 2.378385204}, {1.6, 3.07162994888}, {1.7, 
        3.9283885376336}, {1.8, 4.984634015912992001}, {1.9, 
        6.284253499413850241}, {2., 7.880789269284897294}, {2.1, 
        9.839562908527574699}, {2.2, 12.24026674840364113}, {2.3, 
        15.18012543305244218}, {2.4, 18.77775302832397946}, {2.5, 
        23.17785869455525494}, {2.6, 28.55698760735741103}, {2.7, 
        35.13052488097604146}, {2.799999999999999999, 43.16124035479077058}, {
        2.899999999999999999, 52.96971323284474011}, {2.999999999999999999, 
        64.94705014407058293}}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Modify Euler to include the third derivative"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(f3[x_, y_] = 
      \[PartialD]\_x f2[x, y] + \[PartialD]\_y f2[x, y]\ f[x, y]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(2 + 4\ \((x + 2\ y)\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[BoxData[
    \(euler3[{x_, y_}] := {x + h, 
        y + h\ f[x, y] + 1\/2\ h\^2\ f2[x, y] + \(h\^3\ f3[x, y]\)\/\(3!\)}
        \)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(e3t = NestList[euler3, {x0, y0}, NumSteps]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1, 1\/2}, {1.1, 0.7266666666666666667}, {1.2, 1.014568888888888889}, {
        1.3, 1.377260136296296296}, {1.4, 1.831293713129876543}, {1.5, 
        2.396886721635955885}, {1.6, 3.098730982691380788}, {1.7, 
        3.966983440193739735}, {1.8, 5.038475774956620797}, {1.9, 
        6.358191746480352866}, {2., 7.981071519701337634}, {2.1, 
        9.974215349395233698}, {2.2, 12.41957501339471209}, {2.3, 
        15.4172409496927417}, {2.4, 19.08945694655806853}, {2.5, 
        23.58552341739625436}, {2.6, 29.08778593377995866}, {2.7, 
        35.81894922045658951}, {2.799999999999999999, 44.05100998125098132}, {
        2.899999999999999999, 54.11616685710119852}, {2.999999999999999999, 
        66.42014512147293046}}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Modify Euler to include the fourth derivative"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(f4[x_, y_] = 
      \[PartialD]\_x f3[x, y] + \[PartialD]\_y f3[x, y]\ f[x, y]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(4 + 8\ \((x + 2\ y)\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[BoxData[
    \(euler4[{x_, y_}] := {x + h, 
        y + h\ f[x, y] + 1\/2\ h\^2\ f2[x, y] + \(h\^3\ f3[x, y]\)\/\(3!\) + 
          \(h\^4\ f4[x, y]\)\/\(4!\)}\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(e4t = NestList[euler4, {x0, y0}, NumSteps]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1, 1\/2}, {1.1, 0.72675}, {1.2, 1.01477245}, {1.3, 1.37763307043}, {
        1.4, 1.831901032223202}, {1.5, 2.397813920757418923}, {1.6, 
        3.100089922813111472}, {1.7, 3.968919831723934352}, {1.8, 
        5.041178682467613418}, {1.9, 6.361905642765943029}, {2., 
        7.986111552074322815}, {2.1, 9.980986649703577887}, {2.2, 
        12.42859709394795003}, {2.3, 15.42917849054802617}, {2.4, 
        19.10515860835535916}, {2.5, 23.60607072424523568}, {2.6, 
        29.11455478259313086}, {2.7, 35.85368721145925003}, {
        2.799999999999999999, 44.09593356007632799}, {2.899999999999999999, 
        54.17408325027722701}, {2.999999999999999999, 66.49460528188860507}}
      \)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Plot results individually and all together"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(\(p1p = ListPlot[e1t]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.47619 0.0147151 0.0127481 [
[(1.5)] .2619 .01472 0 2 Msboxa
[(2)] .5 .01472 0 2 Msboxa
[(2.5)] .7381 .01472 0 2 Msboxa
[(3)] .97619 .01472 0 2 Msboxa
[(10)] .01131 .1422 1 0 Msboxa
[(20)] .01131 .26968 1 0 Msboxa
[(30)] .01131 .39716 1 0 Msboxa
[(40)] .01131 .52464 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(1.5)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(2)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(2.5)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(3)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .1422 m
.03006 .1422 L
s
P
[(10)] .01131 .1422 1 0 Mshowa
p
.002 w
.02381 .26968 m
.03006 .26968 L
s
P
[(20)] .01131 .26968 1 0 Mshowa
p
.002 w
.02381 .39716 m
.03006 .39716 L
s
P
[(30)] .01131 .39716 1 0 Mshowa
p
.002 w
.02381 .52464 m
.03006 .52464 L
s
P
[(40)] .01131 .52464 1 0 Mshowa
p
.001 w
.02381 .04021 m
.02756 .04021 L
s
P
p
.001 w
.02381 .06571 m
.02756 .06571 L
s
P
p
.001 w
.02381 .0912 m
.02756 .0912 L
s
P
p
.001 w
.02381 .1167 m
.02756 .1167 L
s
P
p
.001 w
.02381 .16769 m
.02756 .16769 L
s
P
p
.001 w
.02381 .19319 m
.02756 .19319 L
s
P
p
.001 w
.02381 .21868 m
.02756 .21868 L
s
P
p
.001 w
.02381 .24418 m
.02756 .24418 L
s
P
p
.001 w
.02381 .29517 m
.02756 .29517 L
s
P
p
.001 w
.02381 .32067 m
.02756 .32067 L
s
P
p
.001 w
.02381 .34616 m
.02756 .34616 L
s
P
p
.001 w
.02381 .37166 m
.02756 .37166 L
s
P
p
.001 w
.02381 .42265 m
.02756 .42265 L
s
P
p
.001 w
.02381 .44815 m
.02756 .44815 L
s
P
p
.001 w
.02381 .47365 m
.02756 .47365 L
s
P
p
.001 w
.02381 .49914 m
.02756 .49914 L
s
P
p
.001 w
.02381 .55013 m
.02756 .55013 L
s
P
p
.001 w
.02381 .57563 m
.02756 .57563 L
s
P
p
.001 w
.02381 .60113 m
.02756 .60113 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
.008 w
.02381 .02109 Mdot
.07143 .02364 Mdot
.11905 .02683 Mdot
.16667 .03078 Mdot
.21429 .03565 Mdot
.2619 .04162 Mdot
.30952 .04891 Mdot
.35714 .05779 Mdot
.40476 .06857 Mdot
.45238 .08164 Mdot
.5 .09745 Mdot
.54762 .11654 Mdot
.59524 .13958 Mdot
.64286 .16736 Mdot
.69048 .20082 Mdot
.7381 .24111 Mdot
.78571 .28957 Mdot
.83333 .34786 Mdot
.88095 .41793 Mdot
.92857 .50214 Mdot
.97619 .60332 Mdot
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(Show[p, p1p]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.47619 0.0147151 0.00885149 [
[(1.5)] .2619 .01472 0 2 Msboxa
[(2)] .5 .01472 0 2 Msboxa
[(2.5)] .7381 .01472 0 2 Msboxa
[(3)] .97619 .01472 0 2 Msboxa
[(10)] .01131 .10323 1 0 Msboxa
[(20)] .01131 .19174 1 0 Msboxa
[(30)] .01131 .28026 1 0 Msboxa
[(40)] .01131 .36877 1 0 Msboxa
[(50)] .01131 .45729 1 0 Msboxa
[(60)] .01131 .5458 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(1.5)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(2)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(2.5)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(3)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .10323 m
.03006 .10323 L
s
P
[(10)] .01131 .10323 1 0 Mshowa
p
.002 w
.02381 .19174 m
.03006 .19174 L
s
P
[(20)] .01131 .19174 1 0 Mshowa
p
.002 w
.02381 .28026 m
.03006 .28026 L
s
P
[(30)] .01131 .28026 1 0 Mshowa
p
.002 w
.02381 .36877 m
.03006 .36877 L
s
P
[(40)] .01131 .36877 1 0 Mshowa
p
.002 w
.02381 .45729 m
.03006 .45729 L
s
P
[(50)] .01131 .45729 1 0 Mshowa
p
.002 w
.02381 .5458 m
.03006 .5458 L
s
P
[(60)] .01131 .5458 1 0 Mshowa
p
.001 w
.02381 .03242 m
.02756 .03242 L
s
P
p
.001 w
.02381 .05012 m
.02756 .05012 L
s
P
p
.001 w
.02381 .06782 m
.02756 .06782 L
s
P
p
.001 w
.02381 .08553 m
.02756 .08553 L
s
P
p
.001 w
.02381 .12093 m
.02756 .12093 L
s
P
p
.001 w
.02381 .13864 m
.02756 .13864 L
s
P
p
.001 w
.02381 .15634 m
.02756 .15634 L
s
P
p
.001 w
.02381 .17404 m
.02756 .17404 L
s
P
p
.001 w
.02381 .20945 m
.02756 .20945 L
s
P
p
.001 w
.02381 .22715 m
.02756 .22715 L
s
P
p
.001 w
.02381 .24485 m
.02756 .24485 L
s
P
p
.001 w
.02381 .26256 m
.02756 .26256 L
s
P
p
.001 w
.02381 .29796 m
.02756 .29796 L
s
P
p
.001 w
.02381 .31567 m
.02756 .31567 L
s
P
p
.001 w
.02381 .33337 m
.02756 .33337 L
s
P
p
.001 w
.02381 .35107 m
.02756 .35107 L
s
P
p
.001 w
.02381 .38648 m
.02756 .38648 L
s
P
p
.001 w
.02381 .40418 m
.02756 .40418 L
s
P
p
.001 w
.02381 .42188 m
.02756 .42188 L
s
P
p
.001 w
.02381 .43959 m
.02756 .43959 L
s
P
p
.001 w
.02381 .47499 m
.02756 .47499 L
s
P
p
.001 w
.02381 .4927 m
.02756 .4927 L
s
P
p
.001 w
.02381 .5104 m
.02756 .5104 L
s
P
p
.001 w
.02381 .5281 m
.02756 .5281 L
s
P
p
.001 w
.02381 .56351 m
.02756 .56351 L
s
P
p
.001 w
.02381 .58121 m
.02756 .58121 L
s
P
p
.001 w
.02381 .59891 m
.02756 .59891 L
s
P
p
.001 w
.02381 .61662 m
.02756 .61662 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
.02381 .01914 m
.06349 .02078 L
.10317 .02278 L
.14286 .02521 L
.18254 .02815 L
.22222 .03169 L
.2619 .03594 L
.30159 .04103 L
.34127 .0471 L
.38095 .05434 L
.42063 .06297 L
.46032 .07322 L
.5 .08541 L
.53968 .09986 L
.57937 .11701 L
.61905 .13734 L
.65873 .16141 L
.69841 .18992 L
.7381 .22367 L
.77778 .26361 L
.81746 .31085 L
.85714 .36673 L
.89683 .43281 L
.93651 .51095 L
.97619 .60332 L
s
P
P
p
.008 w
.02381 .01914 Mdot
.07143 .02091 Mdot
.11905 .02312 Mdot
.16667 .02587 Mdot
.21429 .02925 Mdot
.2619 .0334 Mdot
.30952 .03846 Mdot
.35714 .04462 Mdot
.40476 .05211 Mdot
.45238 .06118 Mdot
.5 .07216 Mdot
.54762 .08542 Mdot
.59524 .10142 Mdot
.64286 .1207 Mdot
.69048 .14394 Mdot
.7381 .17191 Mdot
.78571 .20556 Mdot
.83333 .24603 Mdot
.88095 .29468 Mdot
.92857 .35315 Mdot
.97619 .42341 Mdot
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(p1j = ListPlot[e1t, PlotJoined \[Rule] True]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.47619 0.0147151 0.0127481 [
[(1.5)] .2619 .01472 0 2 Msboxa
[(2)] .5 .01472 0 2 Msboxa
[(2.5)] .7381 .01472 0 2 Msboxa
[(3)] .97619 .01472 0 2 Msboxa
[(10)] .01131 .1422 1 0 Msboxa
[(20)] .01131 .26968 1 0 Msboxa
[(30)] .01131 .39716 1 0 Msboxa
[(40)] .01131 .52464 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(1.5)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(2)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(2.5)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(3)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .1422 m
.03006 .1422 L
s
P
[(10)] .01131 .1422 1 0 Mshowa
p
.002 w
.02381 .26968 m
.03006 .26968 L
s
P
[(20)] .01131 .26968 1 0 Mshowa
p
.002 w
.02381 .39716 m
.03006 .39716 L
s
P
[(30)] .01131 .39716 1 0 Mshowa
p
.002 w
.02381 .52464 m
.03006 .52464 L
s
P
[(40)] .01131 .52464 1 0 Mshowa
p
.001 w
.02381 .04021 m
.02756 .04021 L
s
P
p
.001 w
.02381 .06571 m
.02756 .06571 L
s
P
p
.001 w
.02381 .0912 m
.02756 .0912 L
s
P
p
.001 w
.02381 .1167 m
.02756 .1167 L
s
P
p
.001 w
.02381 .16769 m
.02756 .16769 L
s
P
p
.001 w
.02381 .19319 m
.02756 .19319 L
s
P
p
.001 w
.02381 .21868 m
.02756 .21868 L
s
P
p
.001 w
.02381 .24418 m
.02756 .24418 L
s
P
p
.001 w
.02381 .29517 m
.02756 .29517 L
s
P
p
.001 w
.02381 .32067 m
.02756 .32067 L
s
P
p
.001 w
.02381 .34616 m
.02756 .34616 L
s
P
p
.001 w
.02381 .37166 m
.02756 .37166 L
s
P
p
.001 w
.02381 .42265 m
.02756 .42265 L
s
P
p
.001 w
.02381 .44815 m
.02756 .44815 L
s
P
p
.001 w
.02381 .47365 m
.02756 .47365 L
s
P
p
.001 w
.02381 .49914 m
.02756 .49914 L
s
P
p
.001 w
.02381 .55013 m
.02756 .55013 L
s
P
p
.001 w
.02381 .57563 m
.02756 .57563 L
s
P
p
.001 w
.02381 .60113 m
.02756 .60113 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.004 w
.02381 .02109 m
.07143 .02364 L
.11905 .02683 L
.16667 .03078 L
.21429 .03565 L
.2619 .04162 L
.30952 .04891 L
.35714 .05779 L
.40476 .06857 L
.45238 .08164 L
.5 .09745 L
.54762 .11654 L
.59524 .13958 L
.64286 .16736 L
.69048 .20082 L
.7381 .24111 L
.78571 .28957 L
.83333 .34786 L
.88095 .41793 L
.92857 .50214 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(p2 = ListPlot[e2t, PlotJoined \[Rule] True]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.47619 0.0147151 0.00906283 [
[(1.5)] .2619 .01472 0 2 Msboxa
[(2)] .5 .01472 0 2 Msboxa
[(2.5)] .7381 .01472 0 2 Msboxa
[(3)] .97619 .01472 0 2 Msboxa
[(10)] .01131 .10534 1 0 Msboxa
[(20)] .01131 .19597 1 0 Msboxa
[(30)] .01131 .2866 1 0 Msboxa
[(40)] .01131 .37723 1 0 Msboxa
[(50)] .01131 .46786 1 0 Msboxa
[(60)] .01131 .55848 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(1.5)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(2)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(2.5)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(3)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .10534 m
.03006 .10534 L
s
P
[(10)] .01131 .10534 1 0 Mshowa
p
.002 w
.02381 .19597 m
.03006 .19597 L
s
P
[(20)] .01131 .19597 1 0 Mshowa
p
.002 w
.02381 .2866 m
.03006 .2866 L
s
P
[(30)] .01131 .2866 1 0 Mshowa
p
.002 w
.02381 .37723 m
.03006 .37723 L
s
P
[(40)] .01131 .37723 1 0 Mshowa
p
.002 w
.02381 .46786 m
.03006 .46786 L
s
P
[(50)] .01131 .46786 1 0 Mshowa
p
.002 w
.02381 .55848 m
.03006 .55848 L
s
P
[(60)] .01131 .55848 1 0 Mshowa
p
.001 w
.02381 .03284 m
.02756 .03284 L
s
P
p
.001 w
.02381 .05097 m
.02756 .05097 L
s
P
p
.001 w
.02381 .06909 m
.02756 .06909 L
s
P
p
.001 w
.02381 .08722 m
.02756 .08722 L
s
P
p
.001 w
.02381 .12347 m
.02756 .12347 L
s
P
p
.001 w
.02381 .14159 m
.02756 .14159 L
s
P
p
.001 w
.02381 .15972 m
.02756 .15972 L
s
P
p
.001 w
.02381 .17785 m
.02756 .17785 L
s
P
p
.001 w
.02381 .2141 m
.02756 .2141 L
s
P
p
.001 w
.02381 .23222 m
.02756 .23222 L
s
P
p
.001 w
.02381 .25035 m
.02756 .25035 L
s
P
p
.001 w
.02381 .26847 m
.02756 .26847 L
s
P
p
.001 w
.02381 .30473 m
.02756 .30473 L
s
P
p
.001 w
.02381 .32285 m
.02756 .32285 L
s
P
p
.001 w
.02381 .34098 m
.02756 .34098 L
s
P
p
.001 w
.02381 .3591 m
.02756 .3591 L
s
P
p
.001 w
.02381 .39535 m
.02756 .39535 L
s
P
p
.001 w
.02381 .41348 m
.02756 .41348 L
s
P
p
.001 w
.02381 .43161 m
.02756 .43161 L
s
P
p
.001 w
.02381 .44973 m
.02756 .44973 L
s
P
p
.001 w
.02381 .48598 m
.02756 .48598 L
s
P
p
.001 w
.02381 .50411 m
.02756 .50411 L
s
P
p
.001 w
.02381 .52223 m
.02756 .52223 L
s
P
p
.001 w
.02381 .54036 m
.02756 .54036 L
s
P
p
.001 w
.02381 .57661 m
.02756 .57661 L
s
P
p
.001 w
.02381 .59474 m
.02756 .59474 L
s
P
p
.001 w
.02381 .61286 m
.02756 .61286 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.004 w
.02381 .01925 m
.07143 .02129 L
.11905 .02387 L
.16667 .02713 L
.21429 .0312 L
.2619 .03627 L
.30952 .04255 L
.35714 .05032 L
.40476 .05989 L
.45238 .07167 L
.5 .08614 L
.54762 .10389 L
.59524 .12565 L
.64286 .15229 L
.69048 .18489 L
.7381 .22477 L
.78571 .27352 L
.83333 .3331 L
.88095 .40588 L
.92857 .49477 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(p3 = ListPlot[e3t, PlotJoined \[Rule] True]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.47619 0.0147151 0.00886183 [
[(1.5)] .2619 .01472 0 2 Msboxa
[(2)] .5 .01472 0 2 Msboxa
[(2.5)] .7381 .01472 0 2 Msboxa
[(3)] .97619 .01472 0 2 Msboxa
[(10)] .01131 .10333 1 0 Msboxa
[(20)] .01131 .19195 1 0 Msboxa
[(30)] .01131 .28057 1 0 Msboxa
[(40)] .01131 .36919 1 0 Msboxa
[(50)] .01131 .45781 1 0 Msboxa
[(60)] .01131 .54642 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(1.5)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(2)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(2.5)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(3)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .10333 m
.03006 .10333 L
s
P
[(10)] .01131 .10333 1 0 Mshowa
p
.002 w
.02381 .19195 m
.03006 .19195 L
s
P
[(20)] .01131 .19195 1 0 Mshowa
p
.002 w
.02381 .28057 m
.03006 .28057 L
s
P
[(30)] .01131 .28057 1 0 Mshowa
p
.002 w
.02381 .36919 m
.03006 .36919 L
s
P
[(40)] .01131 .36919 1 0 Mshowa
p
.002 w
.02381 .45781 m
.03006 .45781 L
s
P
[(50)] .01131 .45781 1 0 Mshowa
p
.002 w
.02381 .54642 m
.03006 .54642 L
s
P
[(60)] .01131 .54642 1 0 Mshowa
p
.001 w
.02381 .03244 m
.02756 .03244 L
s
P
p
.001 w
.02381 .05016 m
.02756 .05016 L
s
P
p
.001 w
.02381 .06789 m
.02756 .06789 L
s
P
p
.001 w
.02381 .08561 m
.02756 .08561 L
s
P
p
.001 w
.02381 .12106 m
.02756 .12106 L
s
P
p
.001 w
.02381 .13878 m
.02756 .13878 L
s
P
p
.001 w
.02381 .1565 m
.02756 .1565 L
s
P
p
.001 w
.02381 .17423 m
.02756 .17423 L
s
P
p
.001 w
.02381 .20968 m
.02756 .20968 L
s
P
p
.001 w
.02381 .2274 m
.02756 .2274 L
s
P
p
.001 w
.02381 .24512 m
.02756 .24512 L
s
P
p
.001 w
.02381 .26285 m
.02756 .26285 L
s
P
p
.001 w
.02381 .29829 m
.02756 .29829 L
s
P
p
.001 w
.02381 .31602 m
.02756 .31602 L
s
P
p
.001 w
.02381 .33374 m
.02756 .33374 L
s
P
p
.001 w
.02381 .35146 m
.02756 .35146 L
s
P
p
.001 w
.02381 .38691 m
.02756 .38691 L
s
P
p
.001 w
.02381 .40464 m
.02756 .40464 L
s
P
p
.001 w
.02381 .42236 m
.02756 .42236 L
s
P
p
.001 w
.02381 .44008 m
.02756 .44008 L
s
P
p
.001 w
.02381 .47553 m
.02756 .47553 L
s
P
p
.001 w
.02381 .49325 m
.02756 .49325 L
s
P
p
.001 w
.02381 .51098 m
.02756 .51098 L
s
P
p
.001 w
.02381 .5287 m
.02756 .5287 L
s
P
p
.001 w
.02381 .56415 m
.02756 .56415 L
s
P
p
.001 w
.02381 .58187 m
.02756 .58187 L
s
P
p
.001 w
.02381 .5996 m
.02756 .5996 L
s
P
p
.001 w
.02381 .61732 m
.02756 .61732 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.004 w
.02381 .01915 m
.07143 .02115 L
.11905 .02371 L
.16667 .02692 L
.21429 .03094 L
.2619 .03596 L
.30952 .04218 L
.35714 .04987 L
.40476 .05937 L
.45238 .07106 L
.5 .08544 L
.54762 .1031 L
.59524 .12478 L
.64286 .15134 L
.69048 .18388 L
.7381 .22373 L
.78571 .27249 L
.83333 .33214 L
.88095 .40509 L
.92857 .49428 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(p4 = ListPlot[e4t, PlotJoined \[Rule] True]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.452381 0.47619 0.0147151 0.0088519 [
[(1.5)] .2619 .01472 0 2 Msboxa
[(2)] .5 .01472 0 2 Msboxa
[(2.5)] .7381 .01472 0 2 Msboxa
[(3)] .97619 .01472 0 2 Msboxa
[(10)] .01131 .10323 1 0 Msboxa
[(20)] .01131 .19175 1 0 Msboxa
[(30)] .01131 .28027 1 0 Msboxa
[(40)] .01131 .36879 1 0 Msboxa
[(50)] .01131 .45731 1 0 Msboxa
[(60)] .01131 .54583 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.2619 .01472 m
.2619 .02097 L
s
P
[(1.5)] .2619 .01472 0 2 Mshowa
p
.002 w
.5 .01472 m
.5 .02097 L
s
P
[(2)] .5 .01472 0 2 Mshowa
p
.002 w
.7381 .01472 m
.7381 .02097 L
s
P
[(2.5)] .7381 .01472 0 2 Mshowa
p
.002 w
.97619 .01472 m
.97619 .02097 L
s
P
[(3)] .97619 .01472 0 2 Mshowa
p
.001 w
.07143 .01472 m
.07143 .01847 L
s
P
p
.001 w
.11905 .01472 m
.11905 .01847 L
s
P
p
.001 w
.16667 .01472 m
.16667 .01847 L
s
P
p
.001 w
.21429 .01472 m
.21429 .01847 L
s
P
p
.001 w
.30952 .01472 m
.30952 .01847 L
s
P
p
.001 w
.35714 .01472 m
.35714 .01847 L
s
P
p
.001 w
.40476 .01472 m
.40476 .01847 L
s
P
p
.001 w
.45238 .01472 m
.45238 .01847 L
s
P
p
.001 w
.54762 .01472 m
.54762 .01847 L
s
P
p
.001 w
.59524 .01472 m
.59524 .01847 L
s
P
p
.001 w
.64286 .01472 m
.64286 .01847 L
s
P
p
.001 w
.69048 .01472 m
.69048 .01847 L
s
P
p
.001 w
.78571 .01472 m
.78571 .01847 L
s
P
p
.001 w
.83333 .01472 m
.83333 .01847 L
s
P
p
.001 w
.88095 .01472 m
.88095 .01847 L
s
P
p
.001 w
.92857 .01472 m
.92857 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
.02381 .10323 m
.03006 .10323 L
s
P
[(10)] .01131 .10323 1 0 Mshowa
p
.002 w
.02381 .19175 m
.03006 .19175 L
s
P
[(20)] .01131 .19175 1 0 Mshowa
p
.002 w
.02381 .28027 m
.03006 .28027 L
s
P
[(30)] .01131 .28027 1 0 Mshowa
p
.002 w
.02381 .36879 m
.03006 .36879 L
s
P
[(40)] .01131 .36879 1 0 Mshowa
p
.002 w
.02381 .45731 m
.03006 .45731 L
s
P
[(50)] .01131 .45731 1 0 Mshowa
p
.002 w
.02381 .54583 m
.03006 .54583 L
s
P
[(60)] .01131 .54583 1 0 Mshowa
p
.001 w
.02381 .03242 m
.02756 .03242 L
s
P
p
.001 w
.02381 .05012 m
.02756 .05012 L
s
P
p
.001 w
.02381 .06783 m
.02756 .06783 L
s
P
p
.001 w
.02381 .08553 m
.02756 .08553 L
s
P
p
.001 w
.02381 .12094 m
.02756 .12094 L
s
P
p
.001 w
.02381 .13864 m
.02756 .13864 L
s
P
p
.001 w
.02381 .15635 m
.02756 .15635 L
s
P
p
.001 w
.02381 .17405 m
.02756 .17405 L
s
P
p
.001 w
.02381 .20946 m
.02756 .20946 L
s
P
p
.001 w
.02381 .22716 m
.02756 .22716 L
s
P
p
.001 w
.02381 .24486 m
.02756 .24486 L
s
P
p
.001 w
.02381 .26257 m
.02756 .26257 L
s
P
p
.001 w
.02381 .29798 m
.02756 .29798 L
s
P
p
.001 w
.02381 .31568 m
.02756 .31568 L
s
P
p
.001 w
.02381 .33338 m
.02756 .33338 L
s
P
p
.001 w
.02381 .35109 m
.02756 .35109 L
s
P
p
.001 w
.02381 .3865 m
.02756 .3865 L
s
P
p
.001 w
.02381 .4042 m
.02756 .4042 L
s
P
p
.001 w
.02381 .4219 m
.02756 .4219 L
s
P
p
.001 w
.02381 .43961 m
.02756 .43961 L
s
P
p
.001 w
.02381 .47501 m
.02756 .47501 L
s
P
p
.001 w
.02381 .49272 m
.02756 .49272 L
s
P
p
.001 w
.02381 .51042 m
.02756 .51042 L
s
P
p
.001 w
.02381 .52813 m
.02756 .52813 L
s
P
p
.001 w
.02381 .56353 m
.02756 .56353 L
s
P
p
.001 w
.02381 .58124 m
.02756 .58124 L
s
P
p
.001 w
.02381 .59894 m
.02756 .59894 L
s
P
p
.001 w
.02381 .61664 m
.02756 .61664 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.004 w
.02381 .01914 m
.07143 .02115 L
.11905 .0237 L
.16667 .02691 L
.21429 .03093 L
.2619 .03594 L
.30952 .04216 L
.35714 .04985 L
.40476 .05934 L
.45238 .07103 L
.5 .08541 L
.54762 .10307 L
.59524 .12473 L
.64286 .15129 L
.69048 .18383 L
.7381 .22367 L
.78571 .27243 L
.83333 .33209 L
.88095 .40505 L
.92857 .49426 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(Show[p, p1, p2, p3, p4]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"Show", "[", 
      RowBox[{
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", "p1", ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False]}], "]"}]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData["Here is a magnified section of the plot"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(Show[p, p1, p2, p3, p4, PlotRange \[Rule] {{2.7, 2.8}, All}]\)], "Input",\

  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{"Show", "[", 
      RowBox[{
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", "p1", ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", \(PlotRange \[Rule] {{2.7, 2.8}, All}\)}], 
      "]"}]], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Table of results"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    InterpretationBox[
      \(Join[Take[Transpose[e1t], 1], Take[Transpose[e1t], \(-1\)], 
        Take[Transpose[e2t], \(-1\)], Take[Transpose[e3t], \(-1\)], 
        Take[Transpose[e4t], \(-1\)], Take[Transpose[yt], \(-1\)]]\),
      ColumnForm[ 
        Transpose[ 
          Join[ 
            Take[ 
              Transpose[ FE`Conversion`Private`e1t], 1], 
            Take[ 
              Transpose[ FE`Conversion`Private`e1t], -1], 
            Take[ 
              Transpose[ FE`Conversion`Private`e2t], -1], 
            Take[ 
              Transpose[ FE`Conversion`Private`e3t], -1], 
            Take[ 
              Transpose[ FE`Conversion`Private`e4t], -1], 
            Take[ 
              Transpose[ FE`Conversion`Private`yt], -1]]]],
      Editable->False]], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \({1, 1\/2, 1\/2, 1\/2, 1\/2, 0.5}\), 
    \({1.1, 0.7, 0.725, 0.7266666666666666667, 0.72675, 0.7267534477002122917}
      \), 
    \({1.2, 0.95, 1.0105, 1.014568888888888889, 1.01477245, 
      1.0147808720515879}\), 
    \({1.3, 1.26, 1.36981, 1.377260136296296296, 1.37763307043, 
      1.377648500488136219}\), 
    \({1.4, 1.642, 1.8191682, 1.831293713129876543, 1.831901032223202, 
      1.831926160615584505}\), 
    \({1.5, 2.1104, 2.378385204, 2.396886721635955885, 2.397813920757418923, 
      2.39785228557380654}\), 
    \({1.6, 2.68248, 3.07162994888, 3.098730982691380788, 
      3.100089922813111472, 3.100146153420684364}\), 
    \({1.7, 3.378976, 3.9283885376336, 3.966983440193739735, 
      3.968919831723934352, 3.968999958555843234}\), 
    \({1.8, 4.2247712, 4.984634015912992001, 5.038475774956620797, 
      5.041178682467613418, 5.041290530493893501}\), 
    \({1.9, 5.24972544, 6.284253499413850241, 6.358191746480352866, 
      6.361905642765943029, 6.362059330516182618}\), 
    \({2., 6.489670528, 7.880789269284897294, 7.981071519701337634, 
      7.986111552074322815, 7.986320123663312785}\), 
    \({2.1, 7.9876046336, 9.839562908527574699, 9.974215349395233698, 
      9.980986649703577887, 9.981266874292651154}\), 
    \({2.2, 9.79512556032, 12.24026674840364113, 12.41957501339471209, 
      12.42859709394795003, 12.42897047580200205}\), 
    \({2.3, 11.974150672384, 15.18012543305244218, 15.4172409496927417, 
      15.42917849054802617, 15.42967254375211301}\), 
    \({2.4, 14.5989808068608, 18.77775302832397946, 19.08945694655806853, 
      19.10515860835535916, 19.10580846387131234}\), 
    \({2.5, 17.75877696823296, 23.17785869455525494, 23.58552341739625436, 
      23.60607072424523568, 23.60692115398458466}\), 
    \({2.6, 21.560532361879552, 28.55698760735741103, 29.08778593377995866, 
      29.11455478259313086, 29.11566274638668582}\), 
    \({2.7, 26.1326388342554624, 35.13052488097604146, 35.81894922045658951, 
      35.85368721145925003, 35.85512505924626669}\), 
    \({2.799999999999999999, 31.62916660110655488, 43.16124035479077058, 
      44.05100998125098132, 44.09593356007632799, 44.09779305459748467}\), 
    \({2.899999999999999999, 38.23499992132786586, 52.96971323284474011, 
      54.11616685710119852, 54.17408325027722701, 54.17648061662602874}\), 
    \({2.999999999999999999, 46.17199990559343903, 64.94705014407058293, 
      66.42014512147293046, 66.49460528188860507, 66.49768754143029888}\)}], 
  "Output",
  Evaluatable->False,
  LineSpacing->{1.25, 0},
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Illustrative Plots (h=0.5)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(h = 0.5\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0.5\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["One Euler step"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(L = Line[{{x0, y0}, euler[{x0, y0}]}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Line[{{1, 1\/2}, {1.5, 1.5}}]\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Use 4 Euler steps, each h/4 in size."], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(euler4x[{x_, y_}] := {x + h\/4, y + 1\/4\ h\ f[x, y]}\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(e1t4 = NestList[euler4x, {1, 1\/2}, 4]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1, 1\/2}, {1.125, 0.75}, {1.25, 1.078125}, {1.375, 1.50390625}, {1.5, 
        2.0517578125}}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(ep = Point/@e1t4\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({Point[{1, 1\/2}], Point[{1.125, 0.75}], Point[{1.25, 1.078125}], 
      Point[{1.375, 1.50390625}], Point[{1.5, 2.0517578125}]}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(pe4 = ListPlot[e1t4, PlotJoined \[Rule] True]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.88095 1.90476 -0.174942 0.379314 [
[(1.1)] .21429 .20437 0 2 Msboxa
[(1.2)] .40476 .20437 0 2 Msboxa
[(1.3)] .59524 .20437 0 2 Msboxa
[(1.4)] .78571 .20437 0 2 Msboxa
[(1.5)] .97619 .20437 0 2 Msboxa
[(0.5)] .01131 .01472 1 0 Msboxa
[(0.75)] .01131 .10954 1 0 Msboxa
[(1.25)] .01131 .2992 1 0 Msboxa
[(1.5)] .01131 .39403 1 0 Msboxa
[(1.75)] .01131 .48886 1 0 Msboxa
[(2)] .01131 .58369 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21429 .20437 m
.21429 .21062 L
s
P
[(1.1)] .21429 .20437 0 2 Mshowa
p
.002 w
.40476 .20437 m
.40476 .21062 L
s
P
[(1.2)] .40476 .20437 0 2 Mshowa
p
.002 w
.59524 .20437 m
.59524 .21062 L
s
P
[(1.3)] .59524 .20437 0 2 Mshowa
p
.002 w
.78571 .20437 m
.78571 .21062 L
s
P
[(1.4)] .78571 .20437 0 2 Mshowa
p
.002 w
.97619 .20437 m
.97619 .21062 L
s
P
[(1.5)] .97619 .20437 0 2 Mshowa
p
.001 w
.0619 .20437 m
.0619 .20812 L
s
P
p
.001 w
.1 .20437 m
.1 .20812 L
s
P
p
.001 w
.1381 .20437 m
.1381 .20812 L
s
P
p
.001 w
.17619 .20437 m
.17619 .20812 L
s
P
p
.001 w
.25238 .20437 m
.25238 .20812 L
s
P
p
.001 w
.29048 .20437 m
.29048 .20812 L
s
P
p
.001 w
.32857 .20437 m
.32857 .20812 L
s
P
p
.001 w
.36667 .20437 m
.36667 .20812 L
s
P
p
.001 w
.44286 .20437 m
.44286 .20812 L
s
P
p
.001 w
.48095 .20437 m
.48095 .20812 L
s
P
p
.001 w
.51905 .20437 m
.51905 .20812 L
s
P
p
.001 w
.55714 .20437 m
.55714 .20812 L
s
P
p
.001 w
.63333 .20437 m
.63333 .20812 L
s
P
p
.001 w
.67143 .20437 m
.67143 .20812 L
s
P
p
.001 w
.70952 .20437 m
.70952 .20812 L
s
P
p
.001 w
.74762 .20437 m
.74762 .20812 L
s
P
p
.001 w
.82381 .20437 m
.82381 .20812 L
s
P
p
.001 w
.8619 .20437 m
.8619 .20812 L
s
P
p
.001 w
.9 .20437 m
.9 .20812 L
s
P
p
.001 w
.9381 .20437 m
.9381 .20812 L
s
P
p
.002 w
0 .20437 m
1 .20437 L
s
P
p
.002 w
.02381 .01472 m
.03006 .01472 L
s
P
[(0.5)] .01131 .01472 1 0 Mshowa
p
.002 w
.02381 .10954 m
.03006 .10954 L
s
P
[(0.75)] .01131 .10954 1 0 Mshowa
p
.002 w
.02381 .2992 m
.03006 .2992 L
s
P
[(1.25)] .01131 .2992 1 0 Mshowa
p
.002 w
.02381 .39403 m
.03006 .39403 L
s
P
[(1.5)] .01131 .39403 1 0 Mshowa
p
.002 w
.02381 .48886 m
.03006 .48886 L
s
P
[(1.75)] .01131 .48886 1 0 Mshowa
p
.002 w
.02381 .58369 m
.03006 .58369 L
s
P
[(2)] .01131 .58369 1 0 Mshowa
p
.001 w
.02381 .03368 m
.02756 .03368 L
s
P
p
.001 w
.02381 .05265 m
.02756 .05265 L
s
P
p
.001 w
.02381 .07161 m
.02756 .07161 L
s
P
p
.001 w
.02381 .09058 m
.02756 .09058 L
s
P
p
.001 w
.02381 .12851 m
.02756 .12851 L
s
P
p
.001 w
.02381 .14748 m
.02756 .14748 L
s
P
p
.001 w
.02381 .16644 m
.02756 .16644 L
s
P
p
.001 w
.02381 .18541 m
.02756 .18541 L
s
P
p
.001 w
.02381 .22334 m
.02756 .22334 L
s
P
p
.001 w
.02381 .2423 m
.02756 .2423 L
s
P
p
.001 w
.02381 .26127 m
.02756 .26127 L
s
P
p
.001 w
.02381 .28024 m
.02756 .28024 L
s
P
p
.001 w
.02381 .31817 m
.02756 .31817 L
s
P
p
.001 w
.02381 .33713 m
.02756 .33713 L
s
P
p
.001 w
.02381 .3561 m
.02756 .3561 L
s
P
p
.001 w
.02381 .37506 m
.02756 .37506 L
s
P
p
.001 w
.02381 .413 m
.02756 .413 L
s
P
p
.001 w
.02381 .43196 m
.02756 .43196 L
s
P
p
.001 w
.02381 .45093 m
.02756 .45093 L
s
P
p
.001 w
.02381 .46989 m
.02756 .46989 L
s
P
p
.001 w
.02381 .50782 m
.02756 .50782 L
s
P
p
.001 w
.02381 .52679 m
.02756 .52679 L
s
P
p
.001 w
.02381 .54575 m
.02756 .54575 L
s
P
p
.001 w
.02381 .56472 m
.02756 .56472 L
s
P
p
.001 w
.02381 .60265 m
.02756 .60265 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.004 w
.02381 .01472 m
.2619 .10954 L
.5 .23401 L
.7381 .39551 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Taylor quadratic poly through {xx, yy}"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(poly[x_, xx_, yy_] = 
      yy + \((x - xx)\)\ f[xx, yy] + 1\/2\ \((x - xx)\)\^2\ f2[xx, yy]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(yy + \((x - xx)\)\ \((xx + 2\ yy)\) + 
      1\/2\ \((x - xx)\)\^2\ \((1 + 2\ \((xx + 2\ yy)\))\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(\(pp = Plot[poly[x, x0, y0], {x, x0, x0 + h}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.88095 1.90476 -0.166394 0.362218 [
[(1.1)] .21429 .19582 0 2 Msboxa
[(1.2)] .40476 .19582 0 2 Msboxa
[(1.3)] .59524 .19582 0 2 Msboxa
[(1.4)] .78571 .19582 0 2 Msboxa
[(1.5)] .97619 .19582 0 2 Msboxa
[(0.5)] .01131 .01472 1 0 Msboxa
[(0.75)] .01131 .10527 1 0 Msboxa
[(1.25)] .01131 .28638 1 0 Msboxa
[(1.5)] .01131 .37693 1 0 Msboxa
[(1.75)] .01131 .46749 1 0 Msboxa
[(2)] .01131 .55804 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21429 .19582 m
.21429 .20207 L
s
P
[(1.1)] .21429 .19582 0 2 Mshowa
p
.002 w
.40476 .19582 m
.40476 .20207 L
s
P
[(1.2)] .40476 .19582 0 2 Mshowa
p
.002 w
.59524 .19582 m
.59524 .20207 L
s
P
[(1.3)] .59524 .19582 0 2 Mshowa
p
.002 w
.78571 .19582 m
.78571 .20207 L
s
P
[(1.4)] .78571 .19582 0 2 Mshowa
p
.002 w
.97619 .19582 m
.97619 .20207 L
s
P
[(1.5)] .97619 .19582 0 2 Mshowa
p
.001 w
.0619 .19582 m
.0619 .19957 L
s
P
p
.001 w
.1 .19582 m
.1 .19957 L
s
P
p
.001 w
.1381 .19582 m
.1381 .19957 L
s
P
p
.001 w
.17619 .19582 m
.17619 .19957 L
s
P
p
.001 w
.25238 .19582 m
.25238 .19957 L
s
P
p
.001 w
.29048 .19582 m
.29048 .19957 L
s
P
p
.001 w
.32857 .19582 m
.32857 .19957 L
s
P
p
.001 w
.36667 .19582 m
.36667 .19957 L
s
P
p
.001 w
.44286 .19582 m
.44286 .19957 L
s
P
p
.001 w
.48095 .19582 m
.48095 .19957 L
s
P
p
.001 w
.51905 .19582 m
.51905 .19957 L
s
P
p
.001 w
.55714 .19582 m
.55714 .19957 L
s
P
p
.001 w
.63333 .19582 m
.63333 .19957 L
s
P
p
.001 w
.67143 .19582 m
.67143 .19957 L
s
P
p
.001 w
.70952 .19582 m
.70952 .19957 L
s
P
p
.001 w
.74762 .19582 m
.74762 .19957 L
s
P
p
.001 w
.82381 .19582 m
.82381 .19957 L
s
P
p
.001 w
.8619 .19582 m
.8619 .19957 L
s
P
p
.001 w
.9 .19582 m
.9 .19957 L
s
P
p
.001 w
.9381 .19582 m
.9381 .19957 L
s
P
p
.002 w
0 .19582 m
1 .19582 L
s
P
p
.002 w
.02381 .01472 m
.03006 .01472 L
s
P
[(0.5)] .01131 .01472 1 0 Mshowa
p
.002 w
.02381 .10527 m
.03006 .10527 L
s
P
[(0.75)] .01131 .10527 1 0 Mshowa
p
.002 w
.02381 .28638 m
.03006 .28638 L
s
P
[(1.25)] .01131 .28638 1 0 Mshowa
p
.002 w
.02381 .37693 m
.03006 .37693 L
s
P
[(1.5)] .01131 .37693 1 0 Mshowa
p
.002 w
.02381 .46749 m
.03006 .46749 L
s
P
[(1.75)] .01131 .46749 1 0 Mshowa
p
.002 w
.02381 .55804 m
.03006 .55804 L
s
P
[(2)] .01131 .55804 1 0 Mshowa
p
.001 w
.02381 .03283 m
.02756 .03283 L
s
P
p
.001 w
.02381 .05094 m
.02756 .05094 L
s
P
p
.001 w
.02381 .06905 m
.02756 .06905 L
s
P
p
.001 w
.02381 .08716 m
.02756 .08716 L
s
P
p
.001 w
.02381 .12338 m
.02756 .12338 L
s
P
p
.001 w
.02381 .14149 m
.02756 .14149 L
s
P
p
.001 w
.02381 .1596 m
.02756 .1596 L
s
P
p
.001 w
.02381 .17771 m
.02756 .17771 L
s
P
p
.001 w
.02381 .21393 m
.02756 .21393 L
s
P
p
.001 w
.02381 .23205 m
.02756 .23205 L
s
P
p
.001 w
.02381 .25016 m
.02756 .25016 L
s
P
p
.001 w
.02381 .26827 m
.02756 .26827 L
s
P
p
.001 w
.02381 .30449 m
.02756 .30449 L
s
P
p
.001 w
.02381 .3226 m
.02756 .3226 L
s
P
p
.001 w
.02381 .34071 m
.02756 .34071 L
s
P
p
.001 w
.02381 .35882 m
.02756 .35882 L
s
P
p
.001 w
.02381 .39504 m
.02756 .39504 L
s
P
p
.001 w
.02381 .41315 m
.02756 .41315 L
s
P
p
.001 w
.02381 .43127 m
.02756 .43127 L
s
P
p
.001 w
.02381 .44938 m
.02756 .44938 L
s
P
p
.001 w
.02381 .4856 m
.02756 .4856 L
s
P
p
.001 w
.02381 .50371 m
.02756 .50371 L
s
P
p
.001 w
.02381 .52182 m
.02756 .52182 L
s
P
p
.001 w
.02381 .53993 m
.02756 .53993 L
s
P
p
.001 w
.02381 .57615 m
.02756 .57615 L
s
P
p
.001 w
.02381 .59426 m
.02756 .59426 L
s
P
p
.001 w
.02381 .61237 m
.02756 .61237 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
.02381 .01472 m
.06349 .0302 L
.10317 .04647 L
.14286 .06353 L
.18254 .08137 L
.22222 .1 L
.2619 .11942 L
.30159 .13962 L
.34127 .16061 L
.38095 .18238 L
.42063 .20494 L
.46032 .22829 L
.5 .25242 L
.53968 .27734 L
.57937 .30304 L
.61905 .32953 L
.65873 .35681 L
.69841 .38487 L
.7381 .41372 L
.77778 .44336 L
.81746 .47378 L
.85714 .50498 L
.89683 .53698 L
.93651 .56975 L
.97619 .60332 L
s
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Plot Exact solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(\(sh = Plot[s[x], {x, x0, x0 + h}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.88095 1.90476 -0.140356 0.310142 [
[(1.1)] .21429 .16979 0 2 Msboxa
[(1.2)] .40476 .16979 0 2 Msboxa
[(1.3)] .59524 .16979 0 2 Msboxa
[(1.4)] .78571 .16979 0 2 Msboxa
[(1.5)] .97619 .16979 0 2 Msboxa
[(0.5)] .01131 .01472 1 0 Msboxa
[(0.75)] .01131 .09225 1 0 Msboxa
[(1.25)] .01131 .24732 1 0 Msboxa
[(1.5)] .01131 .32486 1 0 Msboxa
[(1.75)] .01131 .40239 1 0 Msboxa
[(2)] .01131 .47993 1 0 Msboxa
[(2.25)] .01131 .55746 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.21429 .16979 m
.21429 .17604 L
s
P
[(1.1)] .21429 .16979 0 2 Mshowa
p
.002 w
.40476 .16979 m
.40476 .17604 L
s
P
[(1.2)] .40476 .16979 0 2 Mshowa
p
.002 w
.59524 .16979 m
.59524 .17604 L
s
P
[(1.3)] .59524 .16979 0 2 Mshowa
p
.002 w
.78571 .16979 m
.78571 .17604 L
s
P
[(1.4)] .78571 .16979 0 2 Mshowa
p
.002 w
.97619 .16979 m
.97619 .17604 L
s
P
[(1.5)] .97619 .16979 0 2 Mshowa
p
.001 w
.0619 .16979 m
.0619 .17354 L
s
P
p
.001 w
.1 .16979 m
.1 .17354 L
s
P
p
.001 w
.1381 .16979 m
.1381 .17354 L
s
P
p
.001 w
.17619 .16979 m
.17619 .17354 L
s
P
p
.001 w
.25238 .16979 m
.25238 .17354 L
s
P
p
.001 w
.29048 .16979 m
.29048 .17354 L
s
P
p
.001 w
.32857 .16979 m
.32857 .17354 L
s
P
p
.001 w
.36667 .16979 m
.36667 .17354 L
s
P
p
.001 w
.44286 .16979 m
.44286 .17354 L
s
P
p
.001 w
.48095 .16979 m
.48095 .17354 L
s
P
p
.001 w
.51905 .16979 m
.51905 .17354 L
s
P
p
.001 w
.55714 .16979 m
.55714 .17354 L
s
P
p
.001 w
.63333 .16979 m
.63333 .17354 L
s
P
p
.001 w
.67143 .16979 m
.67143 .17354 L
s
P
p
.001 w
.70952 .16979 m
.70952 .17354 L
s
P
p
.001 w
.74762 .16979 m
.74762 .17354 L
s
P
p
.001 w
.82381 .16979 m
.82381 .17354 L
s
P
p
.001 w
.8619 .16979 m
.8619 .17354 L
s
P
p
.001 w
.9 .16979 m
.9 .17354 L
s
P
p
.001 w
.9381 .16979 m
.9381 .17354 L
s
P
p
.002 w
0 .16979 m
1 .16979 L
s
P
p
.002 w
.02381 .01472 m
.03006 .01472 L
s
P
[(0.5)] .01131 .01472 1 0 Mshowa
p
.002 w
.02381 .09225 m
.03006 .09225 L
s
P
[(0.75)] .01131 .09225 1 0 Mshowa
p
.002 w
.02381 .24732 m
.03006 .24732 L
s
P
[(1.25)] .01131 .24732 1 0 Mshowa
p
.002 w
.02381 .32486 m
.03006 .32486 L
s
P
[(1.5)] .01131 .32486 1 0 Mshowa
p
.002 w
.02381 .40239 m
.03006 .40239 L
s
P
[(1.75)] .01131 .40239 1 0 Mshowa
p
.002 w
.02381 .47993 m
.03006 .47993 L
s
P
[(2)] .01131 .47993 1 0 Mshowa
p
.002 w
.02381 .55746 m
.03006 .55746 L
s
P
[(2.25)] .01131 .55746 1 0 Mshowa
p
.001 w
.02381 .03022 m
.02756 .03022 L
s
P
p
.001 w
.02381 .04573 m
.02756 .04573 L
s
P
p
.001 w
.02381 .06124 m
.02756 .06124 L
s
P
p
.001 w
.02381 .07674 m
.02756 .07674 L
s
P
p
.001 w
.02381 .10776 m
.02756 .10776 L
s
P
p
.001 w
.02381 .12326 m
.02756 .12326 L
s
P
p
.001 w
.02381 .13877 m
.02756 .13877 L
s
P
p
.001 w
.02381 .15428 m
.02756 .15428 L
s
P
p
.001 w
.02381 .18529 m
.02756 .18529 L
s
P
p
.001 w
.02381 .2008 m
.02756 .2008 L
s
P
p
.001 w
.02381 .21631 m
.02756 .21631 L
s
P
p
.001 w
.02381 .23181 m
.02756 .23181 L
s
P
p
.001 w
.02381 .26283 m
.02756 .26283 L
s
P
p
.001 w
.02381 .27834 m
.02756 .27834 L
s
P
p
.001 w
.02381 .29384 m
.02756 .29384 L
s
P
p
.001 w
.02381 .30935 m
.02756 .30935 L
s
P
p
.001 w
.02381 .34036 m
.02756 .34036 L
s
P
p
.001 w
.02381 .35587 m
.02756 .35587 L
s
P
p
.001 w
.02381 .37138 m
.02756 .37138 L
s
P
p
.001 w
.02381 .38689 m
.02756 .38689 L
s
P
p
.001 w
.02381 .4179 m
.02756 .4179 L
s
P
p
.001 w
.02381 .43341 m
.02756 .43341 L
s
P
p
.001 w
.02381 .44891 m
.02756 .44891 L
s
P
p
.001 w
.02381 .46442 m
.02756 .46442 L
s
P
p
.001 w
.02381 .49544 m
.02756 .49544 L
s
P
p
.001 w
.02381 .51094 m
.02756 .51094 L
s
P
p
.001 w
.02381 .52645 m
.02756 .52645 L
s
P
p
.001 w
.02381 .54196 m
.02756 .54196 L
s
P
p
.001 w
.02381 .57297 m
.02756 .57297 L
s
P
p
.001 w
.02381 .58848 m
.02756 .58848 L
s
P
p
.001 w
.02381 .60398 m
.02756 .60398 L
s
P
p
.002 w
.02381 0 m
.02381 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.004 w
.02381 .01472 m
.06349 .02798 L
.10317 .04194 L
.14286 .05664 L
.18254 .0721 L
.22222 .08836 L
.2619 .10544 L
.30159 .12339 L
.34127 .14224 L
.38095 .16203 L
.42063 .1828 L
.46032 .20459 L
.5 .22744 L
.53968 .25141 L
.57937 .27653 L
.61905 .30285 L
.65873 .33044 L
.69841 .35934 L
.7381 .3896 L
.77778 .42129 L
.81746 .45446 L
.85714 .48918 L
.89683 .52552 L
.93651 .56354 L
.97619 .60332 L
s
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Plot Exact solution and three approximations"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(\(Show[sh, pp, pe4, Graphics[L], Graphics[{PointSize[.01], ep}], 
      Graphics[{Text["\<Exact\>", {1.51, 2.5}, {\(-1\), 0}], 
          Text["\<Euler2\>", {1.51, 2.2}, {\(-1\), 0}], 
          Text["\<Euler(h/4)\>", {1.51, 2.00}, {\(-1\), 0}], 
          Text["\<Euler(h)\>", {1.51, 1.5}, {\(-1\), 0}]}], 
      PlotRange \[Rule] {{1, 1.66}, All}, AxesOrigin \[Rule] {1, 0.5}]; \)\)],
   "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.51515 1.51515 -0.132436 0.294302 [
[(1.1)] .15152 .01472 0 2 Msboxa
[(1.2)] .30303 .01472 0 2 Msboxa
[(1.3)] .45455 .01472 0 2 Msboxa
[(1.4)] .60606 .01472 0 2 Msboxa
[(1.5)] .75758 .01472 0 2 Msboxa
[(1.6)] .90909 .01472 0 2 Msboxa
[(0.5)] -0.0125 .01472 1 0 Msboxa
[(1)] -0.0125 .16187 1 0 Msboxa
[(1.5)] -0.0125 .30902 1 0 Msboxa
[(2)] -0.0125 .45617 1 0 Msboxa
[(2.5)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
.002 w
.15152 .01472 m
.15152 .02097 L
s
P
[(1.1)] .15152 .01472 0 2 Mshowa
p
.002 w
.30303 .01472 m
.30303 .02097 L
s
P
[(1.2)] .30303 .01472 0 2 Mshowa
p
.002 w
.45455 .01472 m
.45455 .02097 L
s
P
[(1.3)] .45455 .01472 0 2 Mshowa
p
.002 w
.60606 .01472 m
.60606 .02097 L
s
P
[(1.4)] .60606 .01472 0 2 Mshowa
p
.002 w
.75758 .01472 m
.75758 .02097 L
s
P
[(1.5)] .75758 .01472 0 2 Mshowa
p
.002 w
.90909 .01472 m
.90909 .02097 L
s
P
[(1.6)] .90909 .01472 0 2 Mshowa
p
.001 w
.0303 .01472 m
.0303 .01847 L
s
P
p
.001 w
.06061 .01472 m
.06061 .01847 L
s
P
p
.001 w
.09091 .01472 m
.09091 .01847 L
s
P
p
.001 w
.12121 .01472 m
.12121 .01847 L
s
P
p
.001 w
.18182 .01472 m
.18182 .01847 L
s
P
p
.001 w
.21212 .01472 m
.21212 .01847 L
s
P
p
.001 w
.24242 .01472 m
.24242 .01847 L
s
P
p
.001 w
.27273 .01472 m
.27273 .01847 L
s
P
p
.001 w
.33333 .01472 m
.33333 .01847 L
s
P
p
.001 w
.36364 .01472 m
.36364 .01847 L
s
P
p
.001 w
.39394 .01472 m
.39394 .01847 L
s
P
p
.001 w
.42424 .01472 m
.42424 .01847 L
s
P
p
.001 w
.48485 .01472 m
.48485 .01847 L
s
P
p
.001 w
.51515 .01472 m
.51515 .01847 L
s
P
p
.001 w
.54545 .01472 m
.54545 .01847 L
s
P
p
.001 w
.57576 .01472 m
.57576 .01847 L
s
P
p
.001 w
.63636 .01472 m
.63636 .01847 L
s
P
p
.001 w
.66667 .01472 m
.66667 .01847 L
s
P
p
.001 w
.69697 .01472 m
.69697 .01847 L
s
P
p
.001 w
.72727 .01472 m
.72727 .01847 L
s
P
p
.001 w
.78788 .01472 m
.78788 .01847 L
s
P
p
.001 w
.81818 .01472 m
.81818 .01847 L
s
P
p
.001 w
.84848 .01472 m
.84848 .01847 L
s
P
p
.001 w
.87879 .01472 m
.87879 .01847 L
s
P
p
.001 w
.93939 .01472 m
.93939 .01847 L
s
P
p
.001 w
.9697 .01472 m
.9697 .01847 L
s
P
p
.001 w
1 .01472 m
1 .01847 L
s
P
p
.002 w
0 .01472 m
1 .01472 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0.5)] -0.0125 .01472 1 0 Mshowa
p
.002 w
0 .16187 m
.00625 .16187 L
s
P
[(1)] -0.0125 .16187 1 0 Mshowa
p
.002 w
0 .30902 m
.00625 .30902 L
s
P
[(1.5)] -0.0125 .30902 1 0 Mshowa
p
.002 w
0 .45617 m
.00625 .45617 L
s
P
[(2)] -0.0125 .45617 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(2.5)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .04415 m
.00375 .04415 L
s
P
p
.001 w
0 .07358 m
.00375 .07358 L
s
P
p
.001 w
0 .10301 m
.00375 .10301 L
s
P
p
.001 w
0 .13244 m
.00375 .13244 L
s
P
p
.001 w
0 .1913 m
.00375 .1913 L
s
P
p
.001 w
0 .22073 m
.00375 .22073 L
s
P
p
.001 w
0 .25016 m
.00375 .25016 L
s
P
p
.001 w
0 .27959 m
.00375 .27959 L
s
P
p
.001 w
0 .33845 m
.00375 .33845 L
s
P
p
.001 w
0 .36788 m
.00375 .36788 L
s
P
p
.001 w
0 .39731 m
.00375 .39731 L
s
P
p
.001 w
0 .42674 m
.00375 .42674 L
s
P
p
.001 w
0 .4856 m
.00375 .4856 L
s
P
p
.001 w
0 .51503 m
.00375 .51503 L
s
P
p
.001 w
0 .54446 m
.00375 .54446 L
s
P
p
.001 w
0 .57389 m
.00375 .57389 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.004 w
0 .01472 m
.03157 .0273 L
.06313 .04055 L
.0947 .0545 L
.12626 .06917 L
.15783 .0846 L
.18939 .10081 L
.22096 .11784 L
.25253 .13573 L
.28409 .15451 L
.31566 .17421 L
.34722 .19489 L
.37879 .21658 L
.41035 .23932 L
.44192 .26316 L
.47348 .28814 L
.50505 .31431 L
.53662 .34174 L
.56818 .37045 L
.59975 .40052 L
.63131 .432 L
.66288 .46495 L
.69444 .49943 L
.72601 .53551 L
.75758 .57326 L
s
P
P
p
p
.004 w
0 .01472 m
.03157 .0273 L
.06313 .04052 L
.0947 .05438 L
.12626 .06887 L
.15783 .08401 L
.18939 .09979 L
.22096 .1162 L
.25253 .13325 L
.28409 .15094 L
.31566 .16927 L
.34722 .18824 L
.37879 .20785 L
.41035 .2281 L
.44192 .24898 L
.47348 .2705 L
.50505 .29267 L
.53662 .31547 L
.56818 .33891 L
.59975 .36299 L
.63131 .3877 L
.66288 .41306 L
.69444 .43905 L
.72601 .46568 L
.75758 .49296 L
s
P
P
.004 w
0 .01472 m
.18939 .08829 L
.37879 .18486 L
.56818 .31017 L
.75758 .4714 L
s
0 .01472 m
.75758 .30902 L
s
p
p
.01 w
0 .01472 Mdot
.18939 .08829 Mdot
.37879 .18486 Mdot
.56818 .31017 Mdot
.75758 .4714 Mdot
P
P
p
[(Exact)] .77273 .60332 -1 0 Mshowa
[(Euler2)] .77273 .51503 -1 0 Mshowa
[(Euler\\(h/4\\))] .77273 .45617 -1 0 Mshowa
[(Euler\\(h\\))] .77273 .30902 -1 0 Mshowa
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCacheValid->False]}, Open]]}, Open]]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData[{
  "Runge-Kutta\n",
  StyleBox["(Equivalent to Euler4)",
    FontSize->14],
  ""
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["Initial Data"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(h = 0.1\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(0.1\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \({x0, y0} = {1, 1\/2}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({1, 1\/2}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(f[x_, y_] = x + 2\ y\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(x + 2\ y\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Define the Runge-Kutta Method"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RK[{x_, y_}] := 
      Module[{K1, K2, K3, K4}, K1 = h\ f[x, y]; 
        K2 = h\ f[x + h\/2, y + K1\/2]; K3 = h\ f[x + h\/2, y + K2\/2]; 
        K4 = h\ f[x + h, y + K3]; 
        Return[{x + h, y + 1\/6\ \((K1 + 2\ K2 + 2\ K3 + K4)\)}]]\)], "Input",\

  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Use the Method"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[BoxData[
    \(RKt = NestList[RK, {x0, y0}, 20]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{1, 1\/2}, {1.1, 0.72675}, {1.2, 1.01477245}, {1.3, 1.37763307043}, {
        1.4, 1.831901032223202}, {1.5, 2.397813920757418923}, {1.6, 
        3.100089922813111472}, {1.7, 3.968919831723934352}, {1.8, 
        5.041178682467613418}, {1.9, 6.361905642765943029}, {2., 
        7.986111552074322815}, {2.1, 9.980986649703577887}, {2.2, 
        12.42859709394795003}, {2.3, 15.42917849054802617}, {2.4, 
        19.10515860835535916}, {2.5, 23.60607072424523568}, {2.6, 
        29.11455478259313086}, {2.7, 35.85368721145925003}, {
        2.799999999999999999, 44.09593356007632798}, {2.899999999999999999, 
        54.174083250277227}, {2.999999999999999999, 66.49460528188860506}}\)],
   "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]]}, Open]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{28, Automatic}, {30, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 118, 3, 70, "Title"],
Cell[1852, 56, 609, 10, 70, "Text"],

Cell[CellGroupData[{
Cell[2484, 68, 126, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[2633, 72, 79, 2, 70, "Input"],
Cell[2715, 76, 90, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2837, 81, 93, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[2953, 85, 79, 2, 70, "Input"],
Cell[3035, 89, 91, 3, 70, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3176, 94, 91, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[3290, 98, 399, 11, 70, "Input"],
Cell[3692, 111, 151, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3875, 117, 120, 3, 70, "Input"],
Cell[3998, 122, 131, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4161, 127, 96, 2, 70, "Input"],
Cell[4260, 131, 4140, 422, 70, 3982, 417, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8441, 555, 91, 2, 70, "Section"],
Cell[8535, 559, 137, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[8695, 564, 66, 2, 70, "Input"],
Cell[8764, 568, 85, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8881, 573, 65, 2, 70, "Input"],
Cell[8949, 577, 83, 3, 70, "Output"]
}, Closed]],
Cell[9044, 582, 152, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[9219, 588, 93, 2, 70, "Input"],
Cell[9315, 592, 84, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9431, 597, 110, 2, 70, "Subsection"],
Cell[9544, 601, 101, 2, 70, "Input"],

Cell[CellGroupData[{
Cell[9668, 605, 72, 2, 70, "Input"],
Cell[9743, 609, 116, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9900, 614, 178, 8, 70, "Subsection"],

Cell[CellGroupData[{
Cell[10101, 624, 100, 2, 70, "Input"],
Cell[10204, 628, 623, 10, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10868, 640, 202, 8, 70, "Subsection"],

Cell[CellGroupData[{
Cell[11093, 650, 117, 2, 70, "Input"],
Cell[11213, 654, 750, 12, 70, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12013, 668, 88, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[12124, 672, 413, 11, 70, "Input"],
Cell[12540, 685, 8758, 140, 70, "Output"]
}, Closed]],
Cell[21310, 827, 128, 3, 70, "Input"],

Cell[CellGroupData[{
Cell[21461, 832, 123, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[21607, 836, 121, 3, 70, "Input"],
Cell[21731, 841, 750, 12, 70, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[22531, 855, 122, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[22676, 859, 135, 3, 70, "Input"],
Cell[22814, 864, 103, 3, 70, "Output"]
}, Closed]],
Cell[22929, 869, 128, 3, 70, "Input"],

Cell[CellGroupData[{
Cell[23080, 874, 73, 2, 70, "Input"],
Cell[23156, 878, 160, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[23348, 884, 81, 2, 70, "Input"],
Cell[23432, 888, 118, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[23582, 893, 101, 2, 70, "Input"],
Cell[23686, 897, 730, 12, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24457, 911, 121, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[24601, 915, 137, 3, 70, "Input"],
Cell[24741, 920, 103, 3, 70, "Output"]
}, Closed]],
Cell[24856, 925, 172, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[25051, 931, 101, 2, 70, "Input"],
Cell[25155, 935, 813, 13, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[26009, 950, 122, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[26154, 954, 137, 3, 70, "Input"],
Cell[26294, 959, 103, 3, 70, "Output"]
}, Closed]],
Cell[26409, 964, 203, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[26635, 970, 101, 2, 70, "Input"],
Cell[26739, 974, 778, 13, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27558, 989, 119, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[27700, 993, 84, 2, 70, "Input"],
Cell[27787, 997, 3512, 345, 70, 3354, 340, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],

Cell[CellGroupData[{
Cell[31331, 1344, 71, 2, 70, "Input"],
Cell[31405, 1348, 4546, 448, 70, 4388, 443, "GraphicsData", 
"PostScript", "Graphics"],
Cell[35954, 1798, 178, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[36164, 1805, 103, 2, 70, "Input"],
Cell[36270, 1809, 3447, 344, 70, 3289, 339, "GraphicsData", 
"PostScript", "Graphics"],
Cell[39720, 2155, 178, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[39930, 2162, 102, 2, 70, "Input"],
Cell[40035, 2166, 4024, 408, 70, 3866, 403, "GraphicsData", 
"PostScript", "Graphics"],
Cell[44062, 2576, 178, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[44272, 2583, 102, 2, 70, "Input"],
Cell[44377, 2587, 4070, 414, 70, 3912, 409, "GraphicsData", 
"PostScript", "Graphics"],
Cell[48450, 3003, 178, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[48660, 3010, 102, 2, 70, "Input"],
Cell[48765, 3014, 4071, 414, 70, 3913, 409, "GraphicsData", 
"PostScript", "Graphics"],
Cell[52839, 3430, 178, 5, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[53049, 3437, 82, 2, 70, "Input"],
Cell[53134, 3441, 623, 16, 70, "Output"]
}, Closed]],
Cell[53769, 3459, 113, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[53905, 3463, 121, 3, 70, "Input"],
Cell[54029, 3468, 676, 17, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[54746, 3487, 93, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[54862, 3491, 828, 21, 70, "Input"],
Cell[55693, 3514, 2583, 45, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[58317, 3561, 103, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[58443, 3565, 66, 2, 70, "Input"],
Cell[58512, 3569, 85, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[58629, 3574, 94, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[58746, 3578, 96, 2, 70, "Input"],
Cell[58845, 3582, 111, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[58997, 3587, 116, 2, 70, "Subsection"],
Cell[59116, 3591, 112, 2, 70, "Input"],

Cell[CellGroupData[{
Cell[59251, 3595, 97, 2, 70, "Input"],
Cell[59351, 3599, 177, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[59560, 3605, 75, 2, 70, "Input"],
Cell[59638, 3609, 210, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[59880, 3615, 110, 2, 70, "Input"],
Cell[59993, 3619, 3986, 412, 70, 3828, 407, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[64020, 4033, 118, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[64161, 4037, 154, 4, 70, "Input"],
Cell[64318, 4043, 179, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[64529, 4049, 108, 2, 70, "Input"],
Cell[64640, 4053, 4405, 448, 70, 4247, 443, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[69086, 4503, 99, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[69208, 4507, 97, 2, 70, "Input"],
Cell[69308, 4511, 4702, 480, 70, 4544, 475, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[74051, 4993, 124, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[74198, 4997, 444, 8, 70, "Input"],
Cell[74645, 5007, 4912, 483, 70, 4754, 478, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[79616, 5492, 156, 7, 70, "Title"],

Cell[CellGroupData[{
Cell[79795, 5501, 89, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[79907, 5505, 66, 2, 70, "Input"],
Cell[79976, 5509, 85, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[80093, 5514, 79, 2, 70, "Input"],
Cell[80175, 5518, 91, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[80298, 5523, 79, 2, 70, "Input"],
Cell[80380, 5527, 90, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[80511, 5532, 106, 2, 70, "Section"],
Cell[80620, 5536, 300, 7, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[80952, 5545, 91, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[81066, 5549, 91, 2, 70, "Input"],
Cell[81160, 5553, 772, 13, 70, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
